//@doc      FIELD HDR CORE
//@module   FIELD.H - Field declarations |
//  
//  This file contains the declaration of the field classes.
//
//@normal   Copyright <cp> 1996 Meta Four Software. All rights reserved.

#ifndef __K4FIELD_H__
#define __K4FIELD_H__

#ifndef __K4CONF_H__
    #error Please include "k4conf.h" before this header file
#endif
    
/////////////////////////////////////////////////////////////////////////////
// Declarations in this file
    
    class c4_Field;                     // data structure description

/////////////////////////////////////////////////////////////////////////////
//@class Fields form a tree describing the underlying data structure.

class c4_Field
{
public: 
//@group Construction / destruction
    //@cmember Constructs a new field.
    c4_Field (const char*&, c4_Field* =0);
    //@cmember Destructor.
    ~c4_Field ();

//@group Structural information
    //@cmember Returns true if this is the root field.
    bool IsRoot() const;
    //@cmember returns the field which contains this one.
    c4_Field& Parent() const;
    //@cmember Returns the index of this field in its parent.
    int Index() const;
    //@cmember Returns the nesting level of this field.
    int Level() const;
    //@cmember Returns the repetition degree of this field.
    int Degree() const;
    //@cmember Returns the enclosing repeating field.
    c4_Field& FindContainer();

//@group Repeating and compound fields
    //@cmember Returns the number of subfields.
    int NumSubFields() const;   
    //@cmember Returns the description of each subfield.
    c4_Field& SubField(int) const;
    //@cmember Returns true if this field contains subtables.
    bool IsRepeating() const;
    //@cmember Returns total number of columns in the subtables.
    int NumSubColumns() const;
    //@cmember Returns the description of each subtable column.
    c4_Field& SubColumn(int) const;
    
//@group Field name and description
    //@cmember Returns name of this field, default omits details.
    c4_String Name(bool =false) const;
    //@cmember Returns the type description of this field, if any.
    c4_String Type() const;
    //@cmember Returns the fully specified name of this field.
    c4_String Tag() const;
    //@cmember Describes the structure, can omit field names.
    c4_String Description(bool =false) const;
    //@cmember Finds the subfield index by name.
    int FindSubField(const char*) const;
    
//@group Column offsets and counts
    //@cmember Returns start of the first column in the table.
    int Offset() const;
    //@cmember Returns number of columns used in the table.
    int Width() const;
    //@cmember Returns depth to the table containing the data.
    int Depth() const;
    //@cmember Finds the field index of a given table column.
    int FindIndex(int) const;
    
private:
    c4_Field (const c4_Field&);         // not implemented
    void operator= (const c4_Field&);   // not implemented

        // a few of these may be redundant
    int _offset;
    int _width;
    int _depth;
    int _index;
    c4_PtrArray _subFields;
    c4_PtrArray _subColumns;
    c4_Field* _parent;
    c4_String _name;
    int _nameLen;
    bool _repeating;
};

/////////////////////////////////////////////////////////////////////////////

#if q4_INLINE
    #include "k4field.inl"
#endif

/////////////////////////////////////////////////////////////////////////////

#endif
